		.NOLIST
;==============================================================================
; C Style Character Classification
;------------------------------------------------------------------------------

; This file contains As65 macros for character classification in the style of
; the C library functions.
;
; All the '_Is' macros take a LABEL as a parameter which will be branched to
; if the condition is true. If the condition is not met then execution
; continues at the instruction immediately following the macro call.
;
; For example:
;
;		JSR ReadKey		; Read a character
;		_IsAlpha AlphaKey	; Is is alphabetic?
;		NOP			; No. execute this
;		...
; AlphaKey:	NOP			; Yes, do this 

;==============================================================================
; Revision History
;
; 12-05-2006 AJ	First Release
; 11-08-2007 AJ Added structured assembly code and more comments.
;------------------------------------------------------------------------------
; $Id: ctype.inc 4 2008-01-14 18:53:51Z BitWise $
;------------------------------------------------------------------------------

; Branch to LABEL if A contains an ASCII character ($00-$7F).

_IsASCII	.MACRO LABEL
		ORA #0
		BPL LABEL
		.ENDM

; Force the character in A into the $00-$7F range.

_ToASCII	.MACRO
		AND #$7F
		.ENDM

;------------------------------------------------------------------------------

; Branch to LABEL if A is in the range $00-$1F or $7F.

_IsControl	.MACRO LABEL
		CMP #' '
		BCC LABEL
		CMP #$7F
		BEQ LABEL
		.ENDM

; Branch to LABEL if A is SPACE or TAB.

_IsBlank	.MACRO LABEL
		CMP #' '
		BEQ LABEL
		CMP #'\t'
		BEQ LABEL
		.ENDM

; Branch to LABEL if A is SPACE, CR, NL or TAB.

_IsSpace	.MACRO LABEL
		CMP #' '
		BEQ LABEL
		CMP #'\r'
		BEQ LABEL
		CMP #'\n'
		BEQ LABEL
		CMP #'\t'
		BEQ LABEL
		.ENDM

;------------------------------------------------------------------------------

; Branch to LABEL if A contains any character that marks the paper.


_IsGraph	.MACRO LABEL
		CMP #' '+1
		IF CS
		 CMP #$7F
	 	 BNE LABEL
		ENDIF
		.ENDM

; Branch to LABEL if A contains any printable character.


_IsPrint	.MACRO LABEL
		CMP #' '
		IF CS
		 CMP #$7F
		 BNE LABEL
		ENDIF
		.ENDM

; Branch to LABEL if A contains a punctuation character.

_IsPunct	.MACRO LABEL
		CMP #'!'
		IF CS
		 CMP #'/'+1
		 BCC LABEL
		 CMP #':'
		 IF CS
		  CMP #'@'+1
		  BCC LABEL
		  CMP #'['
		  IF CS
		   CMP #'`'+1
		   BCC LABEL
		   CMP #'{'
		   IF CS
		    CMP #'~'+1
		    BCC LABEL
		   ENDIF
		  ENDIF
		 ENDIF
		ENDIF
		.ENDM
		
;------------------------------------------------------------------------------

; Branch to LABEL if A contains an octal digit.

_IsOctal	.MACRO LABEL
		CMP #'0'
		IF CS
		 CMP #'7'+1
		 BCC LABEL
		ENDIF
		.ENDM

; Branch to LABEL if A contains a decimal digit.

_IsDigit	.MACRO LABEL
		CMP #'0'
		IF CS
		 CMP #'9'+1
		 BCC LABEL
		ENDIF
		.ENDM

; Branch to LABEL if A contains a hexadecimal digit.

_IsHexDigit	.MACRO LABEL
		CMP #'0'
		IF CS
		 CMP #'9'+1
		 BCC LABEL
		 CMP #'A'
		 IF CS
		  CMP #'F'+1
		  BCC LABEL
		  CMP #'a'
		  IF CS
		   CMP #'z'+1
		   BCC LABEL
		  ENDIF
		 ENDIF
		ENDIF
		.ENDM

;------------------------------------------------------------------------------

; Branch to LABEL if A contains an UPPER case character.

_IsUpper	.MACRO LABEL
		CMP #'A'
		IF CS
		 CMP #'Z'+1
		 BCC LABEL
		ENDIF
		.ENDM

; Branch to LABEL if A contains a lower case character.

_IsLower	.MACRO LABEL
		CMP #'a'
		IF CS
		 CMP #'z'+1
		 BCC LABEL
		ENDIF
		.ENDM

; Branch to LABEL if A contains a letter.

_IsAlpha	.MACRO LABEL
		CMP #'A'
		IF CS
		 CMP #'Z'+1
		 BCC LABEL
		 CMP #'a'
		 IF CS
		  CMP #'z'+1
		  BCC LABEL
		 ENDIF
		ENDIF
		.ENDM

; Branch to LABEL if A contains a letter or a digit..

_IsAlnum	.MACRO LABEL
		CMP #'0'
		IF CS
		 CMP #'9'+1
		 BCC LABEL
		 CMP #'A'
		 IF CS
		  CMP #'Z'+1
		  BCC LABEL
		  CMP #'a'
		  IF CS
		   CMP #'z'+1
		   BCC LABEL
		  ENDIF
		 ENDIF
		ENDIF
		.ENDM

; If A contains a lower case letter make it UPPER case.

_ToUpper	.MACRO
		CMP #'a'
		IF CS
		 CMP #'z'+1
		 IF CC
		  SBC #31
		 ENDIF
		ENDIF
		.ENDM

; If A contains an UPPER case letter make if lower case.

_ToLower	.MACRO
		CMP #'A'
		IF CS
		 CMP #'Z'+1
		 IF CC
		  ADC #32
		 ENDIF
		ENDIF
		.ENDM

		.LIST